

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Bank Transaction Approved Lists'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
            <div class="row mb-4">
              <div class="col-lg-4">
                <form method="get" action="<?php echo e(route('admin.bank_transaction_approved.search')); ?>">
                  <div class="input-group mb-2 col-12">
                     <input type="text" class="form-control" placeholder="Search..." name="q" autocomplete="off" value="">
                     <select class="form-control" name="type">
                        <option value="account_number"><?php echo e(__('Search By Account Number')); ?></option>
                        <option value="trx"><?php echo e(__('Search By Trx')); ?></option>
                     </select>
                     <div class="input-group-append">
                        <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i>
                        </button>
                     </div>
                  </div>
                </form>
              </div>
              <div class="col-lg-8">
                <form method="get" action="<?php echo e(route('admin.bank_transaction_approved.search')); ?>">
                <input type="hidden" name="type" value="duration">
                <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group row">
                        <div class="col-lg-3 d-flex align-items-center">
                          <?php echo e(__('Start Date')); ?>

                       </div>
                       <div class="col-lg-9">
                          <input type="date" class="form-control" name="start_date">
                       </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group row">
                        <div class="col-lg-3 d-flex align-items-center">
                          <?php echo e(__('End Date')); ?>

                       </div>
                       <div class="col-lg-9 input-group">
                          <input type="date" class="form-control" name="end_date">
                          <div class="input-group-append">                                            
                            <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                         </div>
                       </div>
                      </div>
                    </div>
                </div>
              </form>
            </div>
            <?php if(Session::has('success')): ?>
            <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
            <?php endif; ?>
            <?php if(Session::has('error')): ?>
            <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
            <?php endif; ?>
            <div class="table-responsive">
                <table class="table table-striped" id="table-2">
                  <thead>
                    <tr>
                      <th><?php echo e(__('User')); ?></th>
                      <th><?php echo e(__('Account')); ?></th>
                      <th><?php echo e(__('Trx')); ?></th>
                      <th><?php echo e(__('Bank')); ?></th>
                      <th><?php echo e(__('Amount')); ?></th>
                      <th><?php echo e(__('Date')); ?></th>
                      <th><?php echo e(__('Status')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $transaction_approved; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($row->user->name); ?></td>
                      <td><?php echo e($row->user->account_number); ?></td>
                      <td><?php echo e($row->transaction->trxid); ?></td>
                      <td><?php echo e($row->bank->name); ?></td>
                      <td><?php echo e($row->amount); ?></td>
                      <td><?php echo e(date('d-m-Y', strtotime($row->created_at))); ?></td>
                      <td>
                        <?php if($row->status == 1): ?>
                        <span class="badge badge-success"><?php echo e(__('Approved')); ?></span>
                        <?php endif; ?>
                      </td>
                      
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                  <?php echo e($transaction_approved->links('vendor.pagination.bootstrap-4')); ?>

                </table>
            </div>
          </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/admin/transaction/bank_transaction_approved.blade.php ENDPATH**/ ?>