

<?php $__env->startSection('content'); ?>
<!-- dahboard area start -->
<section>
    <div class="dashboard-area pt-150 pb-100">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-9">
                    <div class="main-container">
                        <div class="header-section">
                            <h4><?php echo e(__('Fixed Deposit Package')); ?></h4>
                        </div>
                        <?php if(Session::has('success')): ?>
                           <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>
                        <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
                        <?php endif; ?>
                        <div class="section-body">
                           <div class="edeposit-area">
                               <div class="row">
                                   <?php $__currentLoopData = $fdr_plans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                  
                                   <div class="col-lg-4">
                                       <div class="single-deposit text-center mb-4">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="deposit-name">
                                                        <h3><?php echo e(ucwords($row->title)); ?></h3>
                                                    </div>
                                                    <div class="requirments-menu">
                                                         <nav>
                                                             <ul>
                                                                 <li><?php echo e(__('Limit')); ?>: $<?php echo e($row->min_amount); ?> - $<?php echo e($row->max_amount); ?></li>
                                                                 <li><?php echo e(__('Duration')); ?>: <?php echo e($row->duration); ?> <?php echo e(__('Days')); ?></li>
                                                                 <li><?php echo e(__('Return')); ?>: <?php echo e($row->percent_return); ?>%</li>
                                                             </ul>
                                                         </nav>
                                                    </div>
                                                    <div class="desposit-action">
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($row->id); ?>"><?php echo e(__('Deposit Now')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                           
                                       </div>
                                   </div>
                                <!-- Modal -->
                                <div class="modal fade model_hide" id="exampleModal<?php echo e($row->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Deposit Package')); ?></h5>
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            <form method="POST" action="<?php echo e(route('user.fixed.deposit.request', $row->id)); ?>" novalidate="" class="basicform">
                                            <?php echo csrf_field(); ?>
                                            <div class="form-group">
                                                <label for="email"><?php echo e(__('Enter Amount')); ?></label>
                                                <input type="number" class="form-control" name="amount" tabindex="1" required autofocus placeholder="<?php echo e(__('Amount')); ?>">
                                            </div>
                                            <div class="form-group">
                                                <div class="button-btn">
                                                    <button type="submit" class="w-100 basicbtn" tabindex="4">
                                                        <?php echo e(__('Submit')); ?>

                                                    </button>
                                                </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               </div>
                           </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- dahboard area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        function success(data) {
            $(".model_hide").modal('hide');
        }
    </script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/user/deposit/fixed_deposit_package.blade.php ENDPATH**/ ?>