

<?php $__env->startPush('css'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/select2.min.css')); ?>">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('content'); ?>
<!-- dahboard area start -->
<section>
    <div class="dashboard-area pt-150 pb-100">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-9">
                    <div class="main-container">
                        <div class="header-section">
                            <h4><?php echo e(__('Other Bank Transfer')); ?></h4>
                        </div>
                        <div class="card">
                            <div class="card-body">
                               <form action="<?php echo e(route('user.transfer.otherbank.confirm')); ?>" method="post">
                                <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Country')); ?></label>
                                                <select name="country" id="country" class="select2country form-control">
                                                    <option value="">-- <?php echo e(__('Select Country')); ?> --</option>
                                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Bank')); ?></label>
                                                <select name="bank" id="banks" class="form-control select2bank"></select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Currency')); ?></label>
                                                <select name="currency" class="form-control">
                                                    <option value="">-- <?php echo e(__('Select Currency')); ?> --</option>
                                                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->title); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Branch')); ?></label>
                                                <input name="branch" class="form-control" type="text" placeholder="<?php echo e(__('Enter Branch Name')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Account Holder Name')); ?></label>
                                                <input type="text" name="account_holder_name" class="form-control" placeholder="<?php echo e(__('Account Holder Name')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Account Number')); ?></label>
                                                <input type="text" class="form-control" name="account_no" placeholder="<?php echo e(__('Enter Account Number')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="form-group">
                                                <label for=""><?php echo e(__('Amount (USD)')); ?></label>
                                                <input type="number" name="amount" class="<?php echo e(Session::has('error') ? 'is-invalid' : ''); ?> form-control" value="<?php echo e(old('amount')); ?>" placeholder="<?php echo e(__('Amount')); ?>">
                                            </div>
                                            <?php if(Session::has('error')): ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e(Session::get('error')); ?></strong>
                                            </span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-lg-12 text-center mt-3">
                                            <div class="button-btn">
                                                <button type="submit" class="d-block w-100"><?php echo e(__('Submit')); ?></button>
                                            </div>
                                        </div>
                                    </div>
                               </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- dahboard area end -->

<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/select2.min.js')); ?>"></script>    
<script>
    (function($) {
        "use strict";

        $('.select2country').select2({
            'placeholder' : 'Select Country'
        });
        $('.select2bank').select2({
            'placeholder' : 'Select Bank'
        });

        //bank list country wise
        $('#country').on('change', function(){
            $('#banks').html('');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: 'POST',
                url:  '<?php echo e(route("user.transfer.otherbank.country")); ?>',
                data: {'country_id' : this.value},
                dataType: 'json',
                success: function(response){ 
                    $.each( response, function( i, bank ) {
                        $('#banks').append(`<option value=${bank.id}>${bank.name}</option>`)
                    });
                },
                error: function(xhr, status, error) 
                {
                    alert('error');
                }
            })
        })
        
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/user/transfer/otherbank.blade.php ENDPATH**/ ?>