

<?php $__env->startSection('content'); ?>
<!-- dahboard area start -->
<section>
    <div class="dashboard-area pt-150 pb-100">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-9">
                    <div class="main-container">
                        <div class="header-section">
                            <h4><?php echo e(__('Deposit History')); ?></h4>
                        </div>
                        <?php if(Session::has('message')): ?>
                        <p class="alert alert-success">
                            <?php echo e(Session::get('message')); ?>

                        </p>
                        <?php endif; ?>
                        <?php if(Session::has('error')): ?>
                        <p class="alert alert-danger">
                            <?php echo e(Session::get('error')); ?>

                        </p>
                        <?php endif; ?>
                        <div class="card">
                            <div class="card-header">
                                <h5><?php echo e(__('Deposit History')); ?></h5>
                            </div>
                            <div class="card-body">
                                <table class="table">
                                    <thead>
                                      <tr>
                                        <th scope="col">#</th>
                                        <th scope="col"><?php echo e(__('Transaction Id')); ?></th>
                                        <th scope="col"><?php echo e(__('Gateway')); ?></th>
                                        <th scope="col"><?php echo e(__('Amount')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                        <th scope="col" class="date"><?php echo e(__('Date')); ?></th>
                                        <th scope="col"><?php echo e(__('View')); ?></th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $deposits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deposit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <tr>
                                            <td><?php echo e($i++); ?></td>
                                            <td><?php echo e($deposit->trx); ?></td>
                                            <td><?php echo e($deposit->getway->name); ?></td>
                                            <td><?php echo e($deposit->amount); ?></td>
                                            <td>
                                                <?php if($deposit->status == 1): ?>
                                                    <div class="badge bg-success">
                                                        <?php echo e(__('success')); ?>

                                                    </div>
                                                    <?php elseif($deposit->status == 2): ?>
                                                    <div class="badge bg-danger">
                                                        <?php echo e(__('success')); ?>

                                                    </div>
                                                    <?php else: ?> 
                                                    <div class="badge bg-warning">
                                                        <?php echo e(__('Rejected')); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </td>
                                            <td class="date"><?php echo e($deposit->created_at->toDateString()); ?></td>
                                            <td>
                                                <a class="btn btn-primary" href="<?php echo e(route('user.edeposit.show',  $deposit->id)); ?>"><span class="iconify" data-icon="carbon:view-filled" data-inline="false"></span></a>
                                            </td>
                                      </tr>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <div class="float-right">
                                    <?php echo e($deposits->links('vendor.pagination.bootstrap-4')); ?>

                                  </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- dahboard area end -->
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\files\script\resources\views/user/edeposit/history.blade.php ENDPATH**/ ?>