<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />

    <title><?php echo e(env('APP_NAME')); ?></title>
     <link rel="icon" href="<?php echo e(asset('uploads/favicon.ico')); ?>">
    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/all.min.css')); ?>">

    <!-- Template CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/components.css')); ?>">
    <?php echo $__env->yieldPushContent('css'); ?>
</head>

<body>
  <div id="app">
    <div class="main-wrapper">
      <!--- Header Section ---->
      <?php echo $__env->make('layouts.backend.partials.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <!--- Sidebar Section --->
      <?php echo $__env->make('layouts.backend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

      <!--- Main Content --->
      <div class="main-content">
        <section class="section">
         <?php echo $__env->yieldContent('head'); ?>
       </section>
      <?php echo $__env->yieldContent('content'); ?>
      </div>

     <!--- Footer Section --->
     <?php echo $__env->make('layouts.backend.partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
  </div>

  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('backend/admin/assets/js/jquery-3.5.1.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/popper.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/bootstrap.min.js')); ?>" ></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/jquery.nicescroll.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/moment.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
  <!-- Template JS File -->
  <script src="<?php echo e(asset('backend/admin/assets/js/scripts.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/form.js')); ?>"></script>
  <!-- Page Specific JS File -->
  <?php echo $__env->yieldPushContent('js'); ?>
  <script src="<?php echo e(asset('backend/admin/assets/js/custom.js')); ?>"></script>
</body>
</html>
<?php /**PATH D:\xampp\htdocs\files\script\resources\views/layouts/backend/app.blade.php ENDPATH**/ ?>