

<?php $__env->startSection('content'); ?>
<!-- dahboard area start -->
   <section>
    <div class="dashboard-area pt-150 pb-100">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-9">
                    <div class="main-container">
                        <div class="header-section">
                            <h4><?php echo e(__('Fixed Deposit History')); ?></h4>
                        </div>
                        <?php if(Session::has('success')): ?>
                           <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
                        <?php endif; ?>
                        <?php if(Session::has('error')): ?>
                        <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
                        <?php endif; ?>
                        <div class="card">
                            <div class="card-header">
                                <h5><?php echo e(__('Fixed Deposit History')); ?></h5>
                            </div>
                            <div class="card-body table-responsive">
                                <table class="table">
                                    <thead>
                                      <tr>
                                        <th scope="col"><?php echo e(__('Package')); ?></th>
                                        <th scope="col"><?php echo e(__('Amount')); ?></th>
                                        <th scope="col"><?php echo e(__('Return Percent')); ?></th>
                                        <th scope="col"><?php echo e(__('Return Total')); ?></th>
                                        <th scope="col"><?php echo e(__('Start Date')); ?></th>
                                        <th scope="col"><?php echo e(__('Return Date')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                      </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $fdr_history; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                      <tr>
                                        <td><?php echo e($row->fdrplan->title); ?></td>
                                        <td><?php echo e($row->amount); ?></td>
                                        <td><?php echo e($row->return_percent); ?></td>
                                        <td><?php echo e($row->return_total); ?></td>
                                        <td><?php echo e($row->created_at->toDateString()); ?></td>
                                        <td><?php echo e(Carbon\Carbon::parse($row->return_date)->toDateString()); ?></td>
                                        <?php if($row->status == 2): ?>
                                        <td>
                                            <span class="badge bg-info"><?php echo e(__('Waiting')); ?></span>
                                        </td>
                                        <?php endif; ?>
                                        <?php if($row->status == 1): ?>
                                        <td>
                                            <span class="badge bg-success"><?php echo e(__('Complete')); ?></span>
                                        </td>
                                        <?php endif; ?>
                                        <?php if($row->status == 0): ?>
                                        <td>
                                            <span class="badge bg-warning"><?php echo e(__('Rejected')); ?></span>
                                        </td>
                                        <?php endif; ?>
                                      </tr>
                                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <div class="float-right">
                                    <?php echo e($fdr_history->links('vendor.pagination.bootstrap-4')); ?>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- dahboard area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/user/deposit/fixed_deposit_history.blade.php ENDPATH**/ ?>