

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
            <h4><?php echo e(__('Payment Gateway Edit')); ?></h4>
            </div>
            <?php if($errors->any()): ?>
              <div class="alert alert-danger">
                  <strong><?php echo e(__('Whoops!')); ?></strong> <?php echo e(__('There were some problems with your input.')); ?><br><br>
                  <ul>
                      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($error); ?></li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('admin.deposit.automatic.gateway.update', $gateway->id)); ?>" enctype="multipart/form-data" class="basicform_with_reload">
              <?php echo csrf_field(); ?>
              <?php echo method_field('PUT'); ?>
              <?php
                  $info_data = json_decode($gateway->data);
              ?>
              <div class="card-body">
                <div class="form-row">
                    <div class="col-lg-4 col-md-4 col-sm-12">
                      <div class="form-group">
                          <label><?php echo e(__('Name')); ?></label>
                          <input type="text" class="form-control" placeholder="Name" required name="name" value="<?php echo e($gateway->name); ?>">
                      </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12">
                      <div class="form-group">
                        <label><?php echo e(__('Logo')); ?></label>
                        <input type="file" class="form-control" name="logo">
                        <br>
                        <img width="100" src="<?php echo e(asset($gateway->logo)); ?>" alt="<?php echo e($gateway->logo); ?>">
                      </div>
                    </div>
                    <div class="col-lg-4 col-md-4 col-sm-12">
                      <div class="form-group">
                          <label><?php echo e(__('Status')); ?></label>
                          <select name="status" class="form-control" >
                            <option value="1" <?php if($gateway->status == 1): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                            <option value="0" <?php if($gateway->status == 0): ?> selected <?php endif; ?>><?php echo e(__('Disable')); ?></option>
                          </select>
                      </div>
                    </div>
                </div>
                <div class="form-row">
                  <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="form-group">
                        <label><?php echo e(__('Rate')); ?> 
                          <?php switch($gateway->id):
                              case (4): ?> (1 USD = ? INR)   <?php break; ?>
                              <?php case (5): ?> (1 USD = ? RM)    <?php break; ?>
                              <?php case (7): ?> (1 USD = ? GHS)  <?php break; ?>
                              <?php default: ?> 
                                (1 USD = ? USD)
                          <?php endswitch; ?>
                        </label>
                        <input type="number" step="any" class="form-control" placeholder="Rate (1USD= ? USD)" required name="rate" value="<?php echo e($gateway->rate); ?>">
                    </div>
                  </div>
                  <div class="col-lg-6 col-md-6 col-sm-12">
                    <div class="form-group">
                        <label><?php echo e(__('Minimum Amount')); ?></label>
                        <input type="number" step="any" class="form-control" placeholder="Minimum Amount" required name="deposit_min" value="<?php echo e($gateway->deposit_min); ?>">
                    </div>
                  </div>
                </div>
                <div class="form-row">
                    
                    <div class="col-lg-6 col-md-6 col-sm-12">
                      <div class="form-group">
                        <label><?php echo e(__('Maximum Amount')); ?></label>
                        <input type="number" step="any" class="form-control" placeholder="Maximum Amount" required name="deposit_max" value="<?php echo e($gateway->deposit_max); ?>">
                      </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="form-group">
                            <label><?php echo e(__('Deposit Charge')); ?></label>
                            
                            <select name="charge_type" class="form-control" id="charge_type">
                              <option value=""><?php echo e(__('Select charge type')); ?></option>
                              <option value="fixed" <?php echo e($gateway->charge_type == 'fixed' ? 'selected' : ''); ?>><?php echo e(__('Fixed')); ?></option>
                              <option value="percentage" <?php echo e($gateway->charge_type == 'percentage' ? 'selected' : ''); ?>><?php echo e(__('Percentage')); ?></option>
                              <option value="both" <?php echo e($gateway->charge_type == 'both' ? 'selected' : ''); ?>><?php echo e(__('Both')); ?></option>
                            </select>
                          </div>
                          <!--- Transaction Charge Fixed --->
                          <div class="form-row">
                            <div class="transaction_fixed col-lg-6 col-md-6 col-sm-12">
                              <div class="form-group">
                                <label><?php echo e(__('Fixed Amount')); ?></label>
                                <input type="number" step="any" class="form-control" name="fix_charge" placeholder="Fixed Amount" value="<?php echo e(($gateway->charge_type == 'fixed' || $gateway->charge_type == 'both') ? $gateway->fix_charge : ''); ?>">
                               </div>
                          </div>
                          <!--- Transaction Charge percentage --->
                          <div class="transaction_percentage col-lg-6 col-md-6 col-sm-12">
                            <div class="form-group">
                             <label><?php echo e(__('Percentage Amount')); ?></label>
                             <input type="number" step="any" class="form-control" name="percent_charge" placeholder="Percentage Amount" value="<?php echo e(($gateway->charge_type == 'percentage' || $gateway->charge_type == 'both') ? $gateway->percent_charge : ''); ?>">
                            </div>
                          </div>
                        </div>
                    </div>
                </div>
                <div class="form-row">
                    <?php $__currentLoopData = $info_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-lg-6 col-md-6 col-sm-12">
                        <div class="form-group">
                          <label><?php echo e(ucwords(str_replace("_"," ",$key))); ?></label>
                          <input type="text" class="form-control" placeholder="" required name="data[<?php echo e($key); ?>]" value="<?php echo e($data); ?>">
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
                <div class="row">
                  <div class="col-lg-12">
                    <button type="submit" class="btn btn-primary btn-lg float-right w-100 basicbtn"><?php echo e(__('Update')); ?></button>
                  </div>
                </div>
              </div>
          </form>
        </div>
    </div>
</div>
<input type="hidden" id="charge_type_data" value="<?php echo e($gateway->charge_type); ?>">
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\files\script\resources\views/admin/deposits/automatic_gateway_edit.blade.php ENDPATH**/ ?>