

<?php $__env->startSection('content'); ?>
<!-- dahboard area start -->
<section>
    <div class="dashboard-area pt-150 pb-100">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('layouts.frontend.partials.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                <div class="col-lg-9">
                    <div class="main-container">
                        <div class="header-section">
                            <h4><?php echo e(__('Withdraw Methods')); ?></h4>
                        </div>
                        <div class="section-body">
                           <div>
                               <div class="row">
                                   <?php $__currentLoopData = $withdraw_methods; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $withdraw_method): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                   <div class="col-lg-4">
                                       <div class="card">
                                           <div class="card-body">
                                                <div class="text-center mb-4">
                                                    <div class="ecurrency-name">
                                                        <h3><?php echo e(ucwords($withdraw_method->title)); ?></h3>
                                                    </div>
                                                    <div class="requirments-menu">
                                                        <nav>
                                                            <ul>
                                                                <li><?php echo e(__('Limit')); ?>: <?php echo e($withdraw_method->min_amount); ?>-<?php echo e($withdraw_method->max_amount); ?></li>
                                                                <li><?php echo e(__('Charge')); ?>: <?php echo e($withdraw_method->charge_type); ?></li>
                                                            </ul>
                                                        </nav>
                                                    </div>
                                                    <div class="desposit-action">
                                                        <a href="#" data-bs-toggle="modal" data-bs-target="#exampleModal<?php echo e($withdraw_method->id); ?>"><?php echo e(__('Transfer')); ?></a>
                                                    </div>
                                                </div>
                                           </div>
                                       </div>
                                   </div>
                                   <!-- Modal -->
                                    <div class="modal fade" id="exampleModal<?php echo e($withdraw_method->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                            <h5 class="modal-title" id="exampleModalLabel"><?php echo e(ucwords($withdraw_method->title)); ?> </h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <form method="POST" action="<?php echo e(route('user.transfer.ecurrency.check', $withdraw_method->id)); ?>" class="basicform" novalidate="">
                                                <?php echo csrf_field(); ?>
                                                <input type="hidden" value="<?php echo e(route('user.transfer.ecurrency.confirm')); ?>" class="redirectUrl">
                                                <div class="form-group">
                                                    <label for="currency"><?php echo e(__('Currency')); ?></label>
                                                    <select name="currency" class="form-select">
                                                        <option value=""><?php echo e(__('Select Currency')); ?></option>
                                                        <?php $__currentLoopData = $withdraw_method->term; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($currency->id); ?>"><?php echo e($currency->title); ?></option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                                <div class="form-group">
                                                    <label for="amount"><?php echo e(__('Enter Amount')); ?></label>
                                                    <input type="number" class="form-control" name="amount" tabindex="1" required autofocus placeholder="<?php echo e(__('Amount')); ?>">
                                                </div>
                                                <div class="form-group">
                                                        <div class="button-btn">
                                                            <button type="submit" class="basicbtn w-100" tabindex="4">
                                                                <?php echo e(__('Submit')); ?>

                                                            </button>
                                                        </div>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                        </div>
                                    </div>
                                   <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                               </div>
                           </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- dahboard area end -->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
    <script>
        "use strict";
        function success(arg){
            var link = $('.redirectUrl').val();
            window.location.href = link;
        }
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/user/transfer/ecurrency.blade.php ENDPATH**/ ?>