<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title><?php echo e(__('Login')); ?> | <?php echo e(env('APP_NAME')); ?></title>

    <!-- General CSS Files -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/all.min.css')); ?>">

    <!-- Template CSS -->
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/components.css')); ?>">
</head>

<body>
  <div id="app">
    <section class="section">
        <div class="container mt-5">
          <div class="row">
            <div class="col-12 col-sm-8 offset-sm-2 col-md-6 offset-md-3 col-lg-6 offset-lg-3 col-xl-4 offset-xl-4">
              <div class="card card-primary">
                <div class="card-header"><h4><?php echo e(__('Login')); ?></h4></div>
                <div class="card-body">
                  <?php if(Session::has('message')): ?>
                  <div class="alert alert-danger">
                     <?php echo e(Session::get('message')); ?>

                  </div>
                  <?php endif; ?>
                  <form method="POST" action="<?php echo e(route('login')); ?>" class="needs-validation" id="login" novalidate="">
                    <?php echo csrf_field(); ?>
                    <div class="form-group">
                      <label for="email"><?php echo e(__('Email')); ?></label>
                      <input id="email" type="email" class="form-control <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="email" tabindex="1" required autofocus value="<?php echo e(old('email')); ?>">
                        <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                        </span>
                      <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <div class="form-group">
                      <div class="d-block">
                          <label for="password" class="control-label"><?php echo e(__('Password')); ?></label>
                        <div class="float-right">
                        <?php if(Route::has('password.request')): ?>
                          <a href="<?php echo e(route('password.request')); ?>" class="text-small">
                            <?php echo e(__('Forgot Password?')); ?>

                          </a>
                        <?php endif; ?>
                        </div>
                      </div>
                      <input id="password" type="password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password" tabindex="2" required autocomplete="current-password">
                      <div class="invalid-feedback">
                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                          <span class="invalid-feedback" role="alert">
                            <strong><?php echo e($message); ?></strong>
                          </span>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                      </div>
                    </div>
                    <div class="form-group">
                      <div class="custom-control custom-checkbox">
                        <input type="checkbox" name="remember" class="custom-control-input" tabindex="3" id="remember-me" <?php echo e(old('remember') ? 'checked' : ''); ?>>
                        <label class="custom-control-label" for="remember-me"><?php echo e(__('Remember Me')); ?></label>
                      </div>
                    </div>
                    <div class="form-group">
                      <button type="submit" class="btn btn-primary btn-lg btn-block" tabindex="4">
                        <?php echo e(__('Login')); ?>

                      </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>
      </div>
    </section>
</div>

  <!-- General JS Scripts -->
  <script src="<?php echo e(asset('backend/admin/assets/js/jquery-3.5.1.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/popper.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/bootstrap.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/jquery.nicescroll.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/moment.min.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/stisla.js')); ?>"></script>

  <!-- Template JS File -->
  <script src="<?php echo e(asset('backend/admin/assets/js/scripts.js')); ?>"></script>
  <script src="<?php echo e(asset('backend/admin/assets/js/custom.js')); ?>"></script>

  <!-- Page Specific JS File -->
  <script src="<?php echo e(asset('backend/admin/assets/js/page/index-0.js')); ?>"></script>

</body>
</html>
<?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/admin/login.blade.php ENDPATH**/ ?>