

<?php $__env->startPush('css'); ?>
  <link rel="stylesheet" href="<?php echo e(asset('backend/admin/assets/css/summernote/summernote-bs4.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header">
            <h4><?php echo e(__('Edit News')); ?></h4>
            </div>
            <?php if($errors->any()): ?>
              <div class="alert alert-danger">
                  <strong><?php echo e(__('Whoops!')); ?></strong> <?php echo e(__('There were some problems with your input.')); ?><br><br>
                  <ul>
                      <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <li><?php echo e($error); ?></li>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </ul>
              </div>
            <?php endif; ?>
            <form method="POST" action="<?php echo e(route('admin.latest_news.update', $ln_edit->id)); ?>" enctype="multipart/form-data" class="basicform">
              <?php echo csrf_field(); ?>
              <?php echo method_field('put'); ?>
              <?php
               $excerpt_info = $ln_edit->excerpt->value;
               $description_info = $ln_edit->description->value;
               $thumimg_info = $ln_edit->thum_image->value;
              ?>
              <div class="card-body">
                <div class="form-group">
                  <label><?php echo e(__('Name')); ?></label>
                  <input type="text" class="form-control" placeholder="Name" required name="name" value="<?php echo e($ln_edit->title); ?>">
                </div>

                <div class="form-group">
                    <label><?php echo e(__('Short Content')); ?></label>
                    <textarea name="excerpt" cols="30" rows="10" class="form-control"><?php echo e($excerpt_info); ?></textarea>
                </div>
          
                <div class="form-group">
                  <label><?php echo e(__('Description')); ?></label>
                  <textarea name="description" class="form-control summernote"><?php echo e($description_info); ?></textarea>
                </div>

              <div class="form-group">
                <div class="custom-file mb-3">
                  <input type="file" class="custom-file-input" id="customFile" name="thum_image">
                  <label class="custom-file-label" for="customFile"><?php echo e(__('Choose file')); ?></label>
                </div>
                <br>
                <img width="100" src="<?php echo e(asset($thumimg_info)); ?>" alt="<?php echo e($thumimg_info); ?>">
              </div>
              <div class="form-group">
                <div class="custom-file mb-3">
                  <label><?php echo e(__('Status')); ?></label>
                  <select name="status" class="form-control">
                   
                    <option value="1" <?php echo e(($ln_edit->status == 1) ? 'selected' : ''); ?>><?php echo e(__('Active')); ?></option>
                    <option value="0" <?php echo e(($ln_edit->status == 0) ? 'selected' : ''); ?>><?php echo e(__('Inactive')); ?></option>
                  </select>
                </div>
              </div>
              <div class="row">
                  <div class="col-lg-12">
                    <button type="submit" class="btn btn-primary btn-lg float-right w-100 basicbtn"><?php echo e(__('Update')); ?></button>
                  </div>
                </div>
              </div>
            </form>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
  <script src="<?php echo e(asset('backend/admin/assets/js/summernote-bs4.js')); ?>"></script>
  <script>
    $('.summernote').summernote({
       height: 300,                 // set editor height
       minHeight: null,             // set minimum height of editor
       maxHeight: null,             // set maximum height of editor
       focus: true                  // set focus to editable area after initializing summernote
     });
  </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\files\script\resources\views/admin/latest_news/edit.blade.php ENDPATH**/ ?>