

<?php $__env->startSection('content'); ?>
<!-- breadcrumb area start -->
<section>
    <div class="breadcrump-area text-center">
        <div class="breadcrump-title">
            <h4><?php echo e(__('News List')); ?></h4>
        </div>
        <div class="breadcrump-body">
            <a href="<?php echo e(url('/')); ?>"><?php echo e(__('Home')); ?></a> <span class="dash">/</span> <span><?php echo e(__('News List')); ?></span>
        </div>
    </div>
</section>
<!-- breadcrumb area end -->

<!-- blog details area start -->
<section>
    <div class="blog-details pt-100 pb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="row">
                        <?php if($news->count() > 0): ?>
                        <?php $__currentLoopData = $news; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-6 mb-30">
                            <div class="single-news">
                                <div class="news-img">
                                    <a href="<?php echo e(route('blog.show',$value->slug)); ?>"><img class="img-fluid" src="<?php echo e(asset($value->thum_image->value)); ?>" alt=""></a>
                                </div>
                                <div class="news-content">
                                    <div class="news-title">
                                        <a href="<?php echo e(route('blog.show',$value->slug)); ?>"><h3><?php echo e($value->title); ?></h3></a>
                                    </div>
                                    <div class="news-des">
                                        <p><?php echo e($value->excerpt->value); ?></p>
                                    </div>
                                    <div class="news-action">
                                        <a href="<?php echo e(route('blog.show',$value->slug)); ?>"><?php echo e(__('Learn More')); ?> <span class="iconify" data-icon="bi:arrow-right" data-inline="false"></span></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php else: ?> 
                        <div class="no-data-found text-center">
                            <p><?php echo e(__('Opps! No Data Found.')); ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <div class="row mt-5">
                        <div class="col-lg-12">
                            <div class="pagination-area-center text-center">
                                <?php echo e($news->links('vendor.pagination.simple-tailwind')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="blog-card">
                        <div class="blog-card-header">
                            <h3><?php echo e(__('Search')); ?></h3>
                        </div>
                        <div class="blog-card-body">
                            <form action="<?php echo e(route('blog.search')); ?>">
                                <input type="text" placeholder="<?php echo e(__('Search')); ?>" name="search" value="<?php echo e(isset($query) != null ? $query : ''); ?>">
                                <button type="submit"><?php echo e(__('Search')); ?></button>
                            </form>
                        </div>
                    </div>
                    <div class="blog-card">
                        <div class="blog-card-header">
                            <h3><?php echo e(__('Latest News')); ?></h3>
                        </div>
                        <div class="blog-card-body">
                            <div class="container">
                                <?php $__currentLoopData = $latest_blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row mb-4 align-items-center">
                                    <div class="col-lg-4 p-0">
                                        <div class="blog-small-img">
                                            <a href="<?php echo e(route('blog.show',$blog->slug)); ?>"><img class="img-fluid" src="<?php echo e(asset($blog->thum_image->value)); ?>" alt=""></a>
                                        </div>
                                    </div>
                                    <div class="col-lg-8">
                                        <div class="blog-small-title">
                                            <a href="<?php echo e(route('blog.show',$blog->slug)); ?>"><h5><?php echo e($blog->title); ?></h5></a>
                                        </div>
                                    </div>
                                </div> 
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- blog details area end -->   
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.frontend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\files\script\resources\views/blog/index.blade.php ENDPATH**/ ?>