

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Currency List'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-lg-6">
                </div>
                <div class="col-lg-6">
                    <div class="add-new-btn">
                        <a href="<?php echo e(route('admin.currency.create')); ?>" class="btn btn-primary float-right"><?php echo e(__('Add New Currency')); ?></a>
                    </div>
                </div>
            </div>
            <?php if(Session::has('message')): ?>
              <div class="alert alert-danger"><?php echo e(Session::get('message')); ?></div>
            <?php endif; ?>
            <div class="table-responsive">
                <table class="table table-striped" id="table-2">
                  <thead>
                    <tr>
                      <th>
                        <div class="custom-checkbox custom-control">
                          <input type="checkbox" data-checkboxes="mygroup" data-checkbox-role="dad" class="custom-control-input" id="checkbox-all">
                          <label for="checkbox-all" class="custom-control-label">&nbsp;</label>
                        </div>
                      </th>
                      <th><?php echo e(__('Title')); ?></th>
                      <th><?php echo e(__('Image')); ?></th>
                      <th><?php echo e(__('Rate')); ?></th>
                      <th><?php echo e(__('Created At')); ?></th>
                      <th><?php echo e(__('Status')); ?></th>
                      <th><?php echo e(__('Action')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $currencies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                      $info = json_decode($currency->currencyMeta->value);
                    ?>
                    <tr>
                      <td>
                        <div class="custom-checkbox custom-control">
                          <input type="checkbox" data-checkboxes="mygroup" class="custom-control-input" id="checkbox-1">
                          <label for="checkbox-1" class="custom-control-label">&nbsp;</label>
                        </div>
                      </td>
                      <td><?php echo e($currency->title); ?></td>
                      <td><img width="80" src="<?php echo e(asset($info->logo)); ?>" alt="<?php echo e($info->logo); ?>"></td>
                      <td><?php echo e($currency->slug); ?></td>
                      <td><?php echo e(date('d-m-Y', strtotime($currency->created_at))); ?></td>
                      <td>
                        <?php echo e($currency->status == 0 ? 'Inactive' : 'Active'); ?>

                      </td>
                      <td>
                        <div class="dropdown d-inline">
                          <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo e(__('Action')); ?>

                          </button>
                          <div class="dropdown-menu">
                            <a class="dropdown-item has-icon" href="#"><i class="fa fa-eye"></i><?php echo e(__('View')); ?></a>
                            <a class="dropdown-item has-icon" href="<?php echo e(route('admin.currency.edit', $currency->id)); ?>"><i class="fa fa-edit"></i><?php echo e(__('Edit')); ?></a>
                            <a class="dropdown-item has-icon delete-confirm" href="javascript:void(0)" data-id=<?php echo e($currency->id); ?>><i class="fa fa-trash"></i><?php echo e(__('Delete')); ?></a>
                            <!-- Delete Form -->
                            <form class="d-none" id="delete_form_<?php echo e($currency->id); ?>" action="<?php echo e(route('admin.currency.destroy', $currency->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            </form>
                          </div>
                        </div>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                 <?php echo e($currencies->links('vendor.pagination.bootstrap-4')); ?>

            </div>
          </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>



<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/admin/currency/index.blade.php ENDPATH**/ ?>