

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Bank Transaction Requests'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
            <div class="row mb-4">
              <div class="col-lg-4">
                <form method="get" action="<?php echo e(route('admin.bank_transaction_request.search')); ?>">
                  <div class="input-group mb-2 col-12">
                     <input type="text" class="form-control" placeholder="Search..." name="q" autocomplete="off" value="">
                     <select class="form-control" name="type">
                        <option value="account_number"><?php echo e(__('Search By Account Number')); ?></option>
                        <option value="trx"><?php echo e(__('Search By Trx')); ?></option>
                     </select>
                     <div class="input-group-append">
                        <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i>
                        </button>
                     </div>
                  </div>
                </form>
              </div>
              <div class="col-lg-8">
                <form method="get" action="<?php echo e(route('admin.bank_transaction_request.search')); ?>">
                <input type="hidden" name="type" value="duration">
                <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group row">
                        <div class="col-lg-3 d-flex align-items-center">
                          <?php echo e(__('Start Date')); ?>

                       </div>
                       <div class="col-lg-9">
                          <input type="date" class="form-control" name="start_date">
                       </div>
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group row">
                        <div class="col-lg-3 d-flex align-items-center">
                          <?php echo e(__('End Date ')); ?>

                       </div>
                       <div class="col-lg-9 input-group">
                          <input type="date" class="form-control" name="end_date">
                          <div class="input-group-append">                                            
                            <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                         </div>
                       </div>
                      </div>
                    </div>
                </div>
              </form>
            </div>
              <div class="col-md-12">
                <?php if(Session::has('success')): ?>
                <div class="alert alert-success"><?php echo e(Session::get('success')); ?></div>
                <?php endif; ?>
                <?php if(Session::has('error')): ?>
                <div class="alert alert-danger"><?php echo e(Session::get('error')); ?></div>
                <?php endif; ?>
              </div>
            <div class="table-responsive">
                <table class="table table-striped" id="table-2">
                  <thead>
                    <tr>
                      <th><?php echo e(__('User')); ?></th>
                      <th><?php echo e(__('Account')); ?></th>
                      <th><?php echo e(__('Trx')); ?></th>
                      <th><?php echo e(__('Bank')); ?></th>
                      <th><?php echo e(__('Amount (USD)')); ?></th>
                      <th><?php echo e(__('Date')); ?></th>
                      <th><?php echo e(__('Status')); ?></th>
                      <th><?php echo e(__('Action')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $transaction_request; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td><?php echo e($row->user->name); ?></td>
                      <td><?php echo e($row->user->account_number); ?></td>
                      <td><?php echo e($row->transaction->trxid); ?></td>
                      <td><?php echo e($row->bank->name); ?></td>
                      <td><?php echo e($row->amount/$row->currency_rate); ?></td>
                      <td><?php echo e(date('d-m-Y', strtotime($row->created_at))); ?></td>
                      <td>
                        <?php if($row->status == 2): ?>
                        <span class="badge badge-danger"><?php echo e(__('Pending')); ?></span>
                        <?php endif; ?>
                      </td>
                      <td>
                        <div class="dropdown d-inline">
                          <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                          <?php echo e(__('Action')); ?>

                          </button>
                          <div class="dropdown-menu">
                            <a class="dropdown-item has-icon" href="<?php echo e(route('admin.bank.transaction.approved',$row->id)); ?>"><i class="fa fa-eye"></i><?php echo e(__('Approved')); ?></a>
                            <a class="dropdown-item has-icon" href="<?php echo e(route('admin.bank_transaction_view', $row->id)); ?>"><i class="fa fa-eye"></i><?php echo e(__('View')); ?></a>
                            <a class="dropdown-item has-icon delete-confirm" href="javascript:void(0)" data-id=<?php echo e($row->id); ?>><i class="fa fa-trash"></i><?php echo e(__('Rejected')); ?></a>
                            <!-- Delete Form -->
                            <form class="d-none" id="delete_form_<?php echo e($row->id); ?>" action="<?php echo e(route('admin.bank.transaction.rejected', $row->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                          </div>
                        </div>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
                <?php echo e($transaction_request->links('vendor.pagination.bootstrap-4')); ?>

            </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/admin/transaction/bank_transaction_request.blade.php ENDPATH**/ ?>