

<?php $__env->startSection('head'); ?>
<?php echo $__env->make('layouts.backend.partials.headersection',['title'=>'Verified Users'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
    <div class="col-12">
      <div class="card">
        <div class="card-body">
            <div class="row mb-4">
                <div class="col-lg-6">
                  <form method="POST" action="<?php echo e(route('admin.user.search')); ?>">
                    <?php echo csrf_field(); ?>
                    <div class="input-group mb-2 col-12">
                       <input type="text" class="form-control" placeholder="Search..." required="" name="src" autocomplete="off" value="">
                       <select class="form-control" name="type">
                          <option value="email"><?php echo e(__('Search By Email')); ?></option>
                          <option value="phone"><?php echo e(__('Search By Phone')); ?></option>
                          <option value="account_number"><?php echo e(__('Search By Account Number')); ?></option>
                       </select>
                       <div class="input-group-append">                                            
                          <button class="btn btn-primary" type="submit"><i class="fas fa-search"></i></button>
                       </div>
                    </div>
                  </form>
                </div>
                <div class="col-lg-6">
                    <div class="add-new-btn">
                        <a href="<?php echo e(route('admin.users.create')); ?>" class="btn btn-primary float-right"><?php echo e(__('Add New user')); ?></a>
                    </div>
                </div>
            </div>
            <div class="table-responsive">
                <table class="table table-striped" id="table-2">
                  <thead>
                    <tr>
                      <th>
                        <div class="custom-checkbox custom-control">
                          <input type="checkbox" data-checkboxes="mygroup" data-checkbox-role="dad" class="custom-control-input" id="checkbox-all">
                          <label for="checkbox-all" class="custom-control-label">&nbsp;</label>
                        </div>
                      </th>
                      <th><?php echo e(__('Name')); ?></th>
                      <th><?php echo e(__('Email')); ?></th>
                      <th><?php echo e(__('Phone')); ?></th>
                      <th><?php echo e(__('Balance')); ?></th>
                      <th><?php echo e(__('Account Number')); ?></th>
                      <th><?php echo e(__('Status')); ?></th>
                      <th><?php echo e(__('Action')); ?></th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__currentLoopData = $verified_users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td>
                        <div class="custom-checkbox custom-control">
                          <input type="checkbox" data-checkboxes="mygroup" class="custom-control-input" id="checkbox-1">
                          <label for="checkbox-1" class="custom-control-label">&nbsp;</label>
                        </div>
                      </td>
                      <td><?php echo e($row->name); ?></td>
                      <td>
                        <?php echo e($row->email); ?>

                      </td>
                      <td>
                        <?php echo e($row->phone); ?>

                      </td>
                      <td><?php echo e($row->balance); ?></td>
                      <td><?php echo e($row->account_number); ?></td>
                      <?php if($row->status == 1): ?>
                      <td class="text-success"><?php echo e(__('Active')); ?></td>
                      <?php endif; ?>
                      <?php if($row->status == 0): ?>
                      <td class="text-danger"><?php echo e(__('Inactive')); ?></td>
                      <?php endif; ?>
                      <td>
                        <div class="dropdown d-inline">
                          <button class="btn btn-primary dropdown-toggle" type="button" id="dropdownMenuButton2" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                            <?php echo e(__('Action')); ?>

                          </button>
                          <div class="dropdown-menu">
                            <a class="dropdown-item has-icon" href="<?php echo e(route('admin.users.edit', $row->id)); ?>"><i class="fa fa-edit"></i><?php echo e(__('edit')); ?></a>
                            <a class="dropdown-item has-icon" href="<?php echo e(url('/login')); ?>"><i class="fa fa-edit"></i><?php echo e(__('Login')); ?></a>
                            <a class="dropdown-item has-icon delete-confirm" href="javascript:void(0)" data-id=<?php echo e($row->id); ?>><i class="fa fa-trash"></i><?php echo e(__('Delete')); ?></a>
                            <!-- Delete Form -->
                            <form class="d-none" id="delete_form_<?php echo e($row->id); ?>" action="<?php echo e(route('admin.users.destroy', $row->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            </form>
                          </div>
                        </div>
                      </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                  </tbody>
                </table>
              </div>
               <?php echo e($verified_users->links('vendor.pagination.bootstrap-4')); ?>

          </div>
      </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('js'); ?>
<script src="<?php echo e(asset('backend/admin/assets/js/sweetalert2.all.min.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layouts.backend.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\E-Bank\script\resources\views/admin/user/verified_users.blade.php ENDPATH**/ ?>